/***********************************************************************

                       CSA Library, Free Evaluation Version 2.0.5 
                                       Release: January 22th 1997 

       Functions to read/write U/S8, U/S16 and U/S32 types
       from/to a little-endian file.
       The return value will be 0 on success, and EOF on failure.


                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSENDIAN_H
#define __CSENDIAN_H

#include "stdio.h"
#include "cstypes.h"

int ReadS8l(FILE *f,   S8 &i);
int ReadU8l(FILE *f,   U8 &i);
int ReadS16l(FILE *f, S16 &i);
int ReadU16l(FILE *f, U16 &i);
int ReadS32l(FILE *f, S32 &i);
int ReadU32l(FILE *f, U32 &i);



int WriteS8l(FILE *f,   S8 i);
int WriteU8l(FILE *f,   U8 i);
int WriteS16l(FILE *f, S16 i);
int WriteU16l(FILE *f, U16 i);
int WriteS32l(FILE *f, S32 i);
int WriteU32l(FILE *f, U32 i);


#endif
